# 
code for testing the diversity regularizer on EBM for the continual learning problem

------------------------------------------------------------------------------------------------------------------------
## Requirements
The current version of the code has been tested with:
* `pytorch 1.4.0`
* `torchvision 0.2.1`


------------------------------------------------------------------------------------------------------------------------
## Training (Boundary-aware setting)

---set div_weight to the hyperparamter beta.

### CIFAR-10:

CUDA_VISIBLE_DEVICES=0 python main.py \
--experiment cifar10 \
--scenario class \
--iters 2000 \
--lr 1e-4 \
--div_weight 1e-12 \
--seed 2 \
--pdf \
--task-boundary \
--save-dir cifar10/boundary-aware/ebm_extended-class-ours-e-12 \
--ebm \


### CIFAR-100:
CUDA_VISIBLE_DEVICES=0 python main.py \
--experiment cifar100 \
--scenario class \
--iters 5000 \
--lr 1e-4 \
--div_weight 1e-12 \
--seed 2 \
--pdf \
--task-boundary \
--save-dir cifar100/boundary-aware/ebm-class-ours-e-12 \
--ebm \



------------------------------------------------------------------------------------------------------------------------
## Training (Boundary-agnostic setting)


### CIFAR-10:

CUDA_VISIBLE_DEVICES=0 python main.py \
--experiment cifar10 \
--scenario class \
--lr 1e-4 \
--seed 2 \
--div_weight 1e-12 \
--pdf \
--epc-per-virtual-task 50 \
--save-dir cifar10/boundary-agnostic/ebm1-class-e-12 \
--ebm \

### CIFAR-100:

CUDA_VISIBLE_DEVICES=0 python main.py \
--experiment cifar100 \
--scenario class \
--lr 1e-4 \
--seed 2 \
--div_weight 1e-12 \
--pdf \
--epc-per-virtual-task 50 \
--save-dir cifar100/boundary-agnostic/ebm-class-e-12 \
--ebm \



















